/*******************************************************
Filename		:  create_bio_temp_tables.sql
Release 		:  c2.0
SIR			:  
Description		:  create temp biological result tables
Author			:  Christine Tsang
Date			:  7/7/2003
                     	7/28/2003 - Temp table name changed from tsraal_ap2 to tsraal_tstart.
                     	7/29/2003 - Updated the code for Bio Sample Pres temp table logic.  
                     	8/27/2003 - SIR 1495 TIR#7 - Nullified well_number and pipe_number when point type not 'WELL HEAD' or 'END OF PIPE'.
				1/16/2004 - SIR 1586 Moved connect string to master install script -JW
				1/21/2004 - added tsmalp_is_number to FDACT_TEMP2 -JW
Comments		:  Run this script after FA_BIO_RESULT_data1.sql and before FA_BIO_RESULT_data2.sql.
	06/09/2004 added station_is_number to biofdact_temp2 table -GT
        7/23/2004 - modified tr_stop_hdatum from varchar2(12) to char(12) - GT.
**********************************************************/

spool create_bio_temp_tables.log

-- field activity related temp tables.

drop index ibr_act_is_num_org_id;
create index ibr_act_is_num_org_id on FA_BIOLOGICAL_RESULT (activity_is_number,organization_id)
tablespace storetindx
storage (initial 10M next 10M)
nologging;

drop table biofdact_temp;
create table biofdact_temp 
tablespace storetdata
storage ( initial 5M next 5M maxextents 500) nologging 
as select distinct activity_is_number,organization_id, 0 flag from FA_BIOLOGICAL_RESULT;
commit;

create index ibft_act_is_num_org_id on biofdact_temp (activity_is_number,organization_id)
tablespace storetindx
storage (initial 3M next 2M)
nologging;

create bitmap index ibft_flag on bioFdact_temp(flag)
tablespace storetindx
storage (initial 2M next 2M maxextents 500)
nologging ;

drop sequence seq_biofdact_temp2;

create sequence seq_biofdact_temp2
start with 1 increment by 1 nomaxvalue nocycle cache 100;


-- creating trawl start AAL temp table
drop table tsraal_tstart;
create table tsraal_tstart 
tablespace storetdata
storage (initial 10M next 5M)
nologging as
select a.* from storet1.tsraal a, storet1.tsmalp p
where a.tsmalp_is_number = p.tsmalp_is_number
  and a.tsmalp_org_id = p.tsmalp_org_id
  and p.type_code = 'ACTIVITY POINT'
  AND a.TSRAAL_TYPE_NAME='Trawl Start';

create index ind_tsraal_tstart_01 on tsraal_tstart(TSMALP_IS_NUMBER,TSMALP_ORG_ID,TSRFDACT_IS_NUMBER,TSRFDACT_ORG_ID,TSRAAL_TYPE_NAME)
tablespace storetindx
storage (initial 5M next 3M)
nologging;

create index ind_tsraal_tstart_02 on tsraal_tstart(TSRFDACT_IS_NUMBER,TSRFDACT_ORG_ID)
tablespace storetindx
storage (initial 5M next 3M)
nologging;

-- creating biofdact_temp2 table
drop table biofdact_temp2;
create table biofdact_temp2 
tablespace storetdata
storage (initial 200M next 100M)
nologging as
select seq_fdact_temp2.nextval activity_isn, ft.activity_is_number , ft.organization_id,
 nvl(AP_ALP.TYPE_CODE,nap_ALP.TYPE_CODE)				LOCATION_POINT_TYPE,
--added 1/21
 nvl(AP_ALP.tsmalp_is_number,nap_ALP.tsmalp_is_number)			tsmalp_is_number,
 nvl(AP_ALP.SEQUENCE_NUMBER,nap_ALP.SEQUENCE_NUMBER)		POINT_SEQUENCE_NUMBER,
  W.ID_NUMBER well_number,
  p.ID_NUMBER pipe_number,
  NVL(AP_ALP.LAT_DEC_DEG_MSR,nap_ALP.LAT_DEC_DEG_MSR)  activity_LATITUDE,
  NVL(AP_ALP.LONG_DEC_DEG_MSR,nap_ALP.LONG_DEC_DEG_MSR) activity_LONGITUDE,
  NVL(AP_ALP.POINT_NAME,nap_ALP.POINT_NAME) POINT_NAME,
  NVL(AP_ALP.GEOPSTNG_SCALE_TXT,nap_ALP.GEOPSTNG_SCALE_TXT) MAP_SCALE,
--
  START_ALP.Point_name			TR_START_POINT_NAME,
  START_ALP.LAT_DEC_DEG_MSR   	TR_START_LATITUDE,
  START_ALP.LONG_DEC_DEG_MSR	      TR_START_LONGITUDE,
  start_alp.geopstng_datum_cd         TR_START_HDATUM,
  START_AAL.BOTTOM_DEPTH_MSR		TR_START_DEPTH,
  START_AAL.BOTTOM_DEPTH_UN_CD     	TR_START_DEPTH_UNIT,
--
  DECODE(AP_AAL.TSRAAL_TYPE_NAME,'Trawl Stop     ',ap_alp.POINT_NAME,null)	TR_STOP_POINT_NAME,
  DECODE(AP_AAL.TSRAAL_TYPE_NAME,'Trawl Stop     ',Ap_ALP.LAT_DEC_DEG_MSR,null)	TR_STOP_LATITUDE,
  DECODE(AP_AAL.TSRAAL_TYPE_NAME,'Trawl Stop     ',Ap_ALP.LONG_DEC_DEG_MSR,null)	TR_STOP_LONGITUDE,
  DECODE(AP_AAL.TSRAAL_TYPE_NAME,'Trawl Stop     ',Ap_ALP.geopstng_datum_cd,null)	TR_STOP_HDATUM,
  DECODE(AP_AAL.TSRAAL_TYPE_NAME,'Trawl Stop     ',ap_AAL.BOTTOM_DEPTH_MSR,null)	TR_STOP_DEPTH,
  DECODE(AP_AAL.TSRAAL_TYPE_NAME,'Trawl Stop     ',ap_AAL.BOTTOM_DEPTH_UN_CD,null)	TR_STOP_DEPTH_UNIT,
--
  nvl(ap_mad_hd.pk_isn,nap_mad_hd.pk_isn) FK_act_mad_hdatum,
  nvl(ap_mad_hm.pk_isn,nap_mad_hm.pk_isn) fk_act_mad_hmethod,
  nap_alp.tsmstatn0is_number station_is_number
from tsraal_ap ap_aal, 
     storet1.tsmalp ap_alp,
     tsraal_nap nap_aal, 
     storet1.tsmalp nap_alp,
     tsraal_tstart start_aal, 
     storet1.tsmalp start_alp,
     storet1.tsmwell w,
     storet1.tsmpipe p,
     storetw.lu_mad_hmethod ap_mad_hm, 
     storetw.lu_mad_hdatum ap_mad_hd,
     storetw.lu_mad_hmethod nap_mad_hm, 
     storetw.lu_mad_hdatum nap_mad_hd, 
     biofdact_temp ft
where FT.activity_IS_NUMBER = AP_AAL.TSRFDACT_IS_NUMBER (+)
  AND FT.organization_id = AP_AAL.TSRFDACT_ORG_ID (+)
  AND AP_AAL.TSMALP_IS_NUMBER  = AP_ALP.TSMALP_IS_NUMBER (+)
  AND AP_AAL.TSMALP_ORG_ID  = AP_ALP.TSMALP_ORG_ID (+)
  AND FT.activity_IS_NUMBER = nap_AAL.TSRFDACT_IS_NUMBER (+)
  AND FT.organization_id= nap_AAL.TSRFDACT_ORG_ID (+)
  AND nap_AAL.TSMALP_IS_NUMBER  = NAP_ALP.TSMALP_IS_NUMBER (+)
  AND nap_AAL.TSMALP_ORG_ID  = NAP_ALP.TSMALP_ORG_ID (+)
  AND FT.activity_IS_NUMBER = START_AAL.TSRFDACT_IS_NUMBER (+)
  AND FT.organization_id= START_AAL.TSRFDACT_ORG_ID (+)
  AND START_AAL.TSMALP_IS_NUMBER  = START_ALP.TSMALP_IS_NUMBER (+)
  AND START_AAL.TSMALP_ORG_ID  = START_ALP.TSMALP_ORG_ID (+)
  and nap_alp.tsmwell_is_number = w.tsmwell_is_number (+)
  and nap_alp.tsmwell_org_id = w.tsmwell_org_id (+)
  and nap_alp.tsmpipe_is_number = p.tsmpipe_is_number (+)
  and nap_alp.tsmpipe_org_id = p.tsmpipe_org_id (+)
  and ap_alp.geopstng_datum_cd = ap_mad_hd.id_code (+)
  and ap_alp.geopstng_method_cd = ap_mad_hM.id_code (+)
  and nap_alp.geopstng_datum_cd = nap_mad_hd.id_code (+)
  and nap_alp.geopstng_method_cd = nap_mad_hM.id_code (+);

-- added to modify tr_stop_hdatum from varchar2(12) to char(12). 7/23/2004.
alter table biofdact_temp2
modify tr_stop_hdatum char(12);

update biofdact_temp2
set WELL_NUMBER = null
where rtrim(LOCATION_POINT_TYPE) <> 'WELL HEAD';
commit;

update biofdact_temp2
set PIPE_NUMBER = null
where rtrim(LOCATION_POINT_TYPE) <> 'END OF PIPE';
commit;

create index ibft2_act_isnorgid on biofdact_temp2(activity_is_number,organization_id) 
tablespace storetindx
storage (initial 10M next 5M)
nologging;

--bio field set temp table
drop table biofieldset_temp;
create table biofieldset_temp
tablespace storetdata
storage (initial 10M next 5M)
nologging as
SELECT activity_isn, f_fieldset(ACTIVITY_IS_NUMBER, ORGANIZATION_ID) field_set
	FROM biofdact_temp2 ft2;
DELETE FROM biofieldset_temp WHERE field_set IS NULL;
COMMIT;


--check biofdact_temp2 data for data problems.
-- This query should not yield any rows.  If any rows are returned then fix the bad data before proceding.

select 'Note:  Following select should not yield any rows. If it returns rows then there is problem with fdact_temp2 data.' from dual;

select activity_is_number,organization_id,count(*)
from biofdact_temp2
group by activity_is_number,organization_id
having count(*)  > 1;

select 'Following delete statement fixes the fdact_temp2 data by deleting duplicate rows by keeping max(rowid)' from dual;

delete from biofdact_temp2 a
where a.rowid < (select max(b.rowid) from biofdact_temp2 b
         where b.activity_is_number = a.activity_is_number
           and b.organization_id = a.organization_id);

commit;

-- lab remark related temp tables.

create index ibr_lbrmk_01 on FA_BIOLOGICAL_RESULT(result_is_number,organization_id)
tablespace storetindx
storage(initial 10M next 10M)
nologging;

analyze index ibr_lbrmk_01 compute statistics;

--BIO SAMPLE PRES TEMP
drop table bio_sample_pres_temp;

create table bio_sample_pres_temp
tablespace storetdata
storage (initial 10M next 10M) nologging as
	select CONTAINER_TYPE_NM,CONTAINER_COLOR,CONTAINER_SIZE_MSR,CONTAINER_SIZE_UN,
		TEMP_PRESERVN_TYPE,TSMPRMVL_IS_NUMBER,TSMPRMVL0IS_NUMBER,TSMPRMVL1IS_NUMBER,
		PRESRV_STRGE_PRCDR,smple.tsrfdact_is_number,smple.tsrfdact_org_id
	from storet1.tsrsmple smple, biofdact_temp tp
	where tp.activity_is_number = smple.tsrfdact_is_number
	and tp.organization_id = smple.tsrfdact_org_id;

update bio_sample_pres_temp tp
set (CONTAINER_TYPE_NM) = (
     select FIELD_VALUE
     from storet.TSMPRMVL b
     where b.tsmprmvl_is_number = tp.tsmprmvl_is_number 
           and b.field_name = 'CONTAINER_TYPE_NM'
           and b.table_name = 'TSRSMPLE')
WHERE TP.TSMPRMVL_IS_NUMBER IS NOT NULL;

update bio_sample_pres_temp tp
set (TEMP_PRESERVN_TYPE) = (
     select FIELD_VALUE
     from storet.TSMPRMVL b
     where b.tsmprmvl_is_number = tp.tsmprmvl1is_number 
           and b.field_name = 'TEMP_PRESERVN_TYPE'
           and b.table_name = 'TSRSMPLE')
WHERE TP.TSMPRMVL1IS_NUMBER IS NOT NULL;

update bio_sample_pres_temp tp
set (CONTAINER_COLOR) = (
     select FIELD_VALUE
     from storet.TSMPRMVL b
     where b.tsmprmvl_is_number = tp.tsmprmvl0is_number 
           and b.field_name = 'CONTAINER_COLOR'
           and b.table_name = 'TSRSMPLE')
WHERE TP.TSMPRMVL0IS_NUMBER IS NOT NULL;
commit;

update bio_sample_pres_temp tp
	set CONTAINER_SIZE_MSR = to_number(NULL)
	WHERE CONTAINER_SIZE_MSR = 0;
commit;

alter table bio_sample_pres_temp add container_desc varchar2(60);

update bio_sample_pres_temp
set container_desc = (container_color||' '||container_type_nm||' '||CONTAINER_SIZE_MSR||' '||CONTAINER_SIZE_UN);

commit;

spool off
